<?php session_start(); ?>
<!DOCTYPE html>
<html lang="en">
<?php 

// Turn off error reporting
error_reporting(0);

// Report runtime errors
error_reporting(E_ERROR | E_WARNING | E_PARSE);

// Report all errors
error_reporting(E_ALL);

// Same as error_reporting(E_ALL);
ini_set("error_reporting", E_ALL);

// Report all errors except E_NOTICE
error_reporting(E_ALL & ~E_NOTICE);
require('../../../includes/connect.php');
?>
<head>
     <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">
    <link rel="icon" type="image/png" sizes="16x16" href="../../plugins/images/favicon.png">
    <title>View Attendance</title>
    <!-- Bootstrap Core CSS -->
    <link href="../bootstrap/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Menu CSS -->
    <link href="../../plugins/bower_components/sidebar-nav/dist/sidebar-nav.min.css" rel="stylesheet">
    <!-- animation CSS -->
    <link href="../css/animate.css" rel="stylesheet">
    <!-- Custom CSS -->
    <link href="../css/style.css" rel="stylesheet">
    <!-- color CSS -->
    <link href="../css/colors/default.css" id="theme" rel="stylesheet">
    <link href="css/vendor/font-awesome.min.css" type="text/css" rel="stylesheet">
     <link href="https://use.fontawesome.com/releases/v5.0.6/css/all.css" rel="stylesheet">
</head>

<body class="fix-header">
    <!-- ============================================================== -->
    <!-- Preloader -->
    <!-- ============================================================== -->
    <div class="preloader">
        <svg class="circular" viewBox="25 25 50 50">
            <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10" />
        </svg>
    </div>
    <!-- ============================================================== -->
    <!-- Wrapper -->
    <!-- ============================================================== -->
<div id="wrapper">
<div class="page-wrapper chiller-theme toggled">
  <a id="show-sidebar" class="btn btn-sm btn-dark" href="#">
    <i class="fas fa-bars"></i>
  </a>
  <nav id="sidebar" class="sidebar-wrapper">
    <div class="sidebar-content">
      <div class="sidebar-brand">
        <a href="#">Tridindia CRM</a>
        <div id="close-sidebar">
          <i class="fas fa-times"></i>
        </div>
      </div>
      <!-- sidebar-header  -->
      <div class="sidebar-menu">
        <ul>
          <li class="header-menu">
            <span>General</span>
          </li>
          <li>
            <a href="../index.php">
              <i class="fa fa-tachometer-alt"></i>
              <span>Dashboard</span>
            </a>
          </li>
          <li class="sidebar-dropdown">
            <a href="#">
              <i class="fa fa-user"></i>
              <span>User Panel</span>
            </a>
            <div class="sidebar-submenu">
              <ul>
                <li>
                  <a href="../attendance/view-attendance.php">Views Attendance</a>
                </li>
                <li>
                  <a href="../leaves/index.php">Apply for Leave</a>
                </li>
                <li>
                  <a href="../leaves/myleave.php">View Leaves</a>
                </li>
                 <li>
                  <a href="../attendance/change-password.php">Change Password</a>
                </li>

              </ul>
            </div>
          </li>
          <?php 
          if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridrole'] == "HR")
          {
          ?>
          <li class="sidebar-dropdown">
            <a  class="waves-effect"> <i class="fa fa-user-secret"></i>
             <span>HR Adminstration</span></a>
            <div class="sidebar-submenu">
              <ul>
                <li>
                  <a href="../newuser.php">Create User</a>
                </li>
                <li>
                  <a href="../viewuser/viewuser.php">Edit User</a>
                </li>
                <li>
                  <a href="../leaves/approveleave.php">Approve Leave</a>
                </li>
                <li>
                  <a href="../add-notice.php">Add New Notice</a>
                </li>
                <li>
                  <a href=".././document/relieving-letter.php">Relieving Letter</a>
                </li>
                <li>
                  <a href=".././document/offer-letter.php">Offer Letter</a>
                </li>
                <li>
                  <a href=".././document/appointment-letter.php">Appointment Letter</a>
                </li>
                <li>
                  <a href=".././document/increment-letter.php">Increment Letter</a>
                </li>
                 <li>
                  <a href=".././document/promotion-letter.php">Promotion Letter</a>
                </li>
                 <li>
                  <a href=".././document/salary-slip.php">Generate Salary & Slips</a>
                </li>
                 <li>
                  <a href=".././document/modify-attendance.php">Modify Attendance</a>
                </li>
                 <li>
                  <a href=".././document/lunch-timings.php">Lunch Timings</a>
                </li>
                 <li>
                  <a href=".././document/birthday.php">Birthday</a>
                </li>
                  <li>
                  <a href=".././attendance/view-attendance-hr.php">View Attendance HR</a>
                </li>
              </ul>
            </div>
          </li>
          <?php
          }
          ?>
          <?php 
          if($_SESSION['tridrole'] == "SuperAdmin")
          {
          ?>    
          <li class="sidebar-dropdown">
            <a href="#">
              <i class="fa fa-chart-line"></i>
              <spasn>Super Admin Panel</span>
            </a>
            <div class="sidebar-submenu">
              <ul>
                <li>
                  <a href="../hr-dashboard.php">HR Dashboard</a>
                </li>
                <li>
                  <a href="../translation-dashboard.php">Translation Dashboard</a>
                </li>
                <li>
                  <a href="../departments.php">Create Departments</a>
                </li>
                <li>
                  <a href="../add-notice.php">Add Notice</a>
                </li>
              </ul>
            </div>
          </li>
          <?php
          }
          ?>
          <?php
            if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridrole'] == "Manager")
            {
            ?>
          <li class="sidebar-dropdown">
            <a href="#">
              <i class="fa fa-globe"></i>
              <span>Manager Admin Panel</span>
            </a>
            <div class="sidebar-submenu">
              <ul>
                <li>
                  <a href="../leaves/approveleave.php">Approve Leave</a>
                </li>
                <li>
                  <a href=".././attendance/view-attendance-hr.php">View Attendance</a>
                </li>
                <li>
                  <a href=".././attendance/logs.php">Modify Attendance Logs</a>
                </li>
              </ul>
            </div>
          </li>
          <?php
          }
          ?>
          <?php 
        if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridcrmrole'] == "Admin" || $_SESSION['tridcrmrole'] == "User")
        {
        ?>
        <li class="header-menu">
            <span>Other</span>
          </li>
           <li class="sidebar-dropdown">
            <a href="#">
              <i class="fa fa-book"></i>
              <span>HR CRM</span>
            </a>
            <div class="sidebar-submenu">
              <ul>
                <?php
if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridcrmrole'] == "Admin")
{
?>

                <li>
                  <a href=".././hr-dashboard.php">HR Dashboard</a>
                </li>
                <?php
}
?>
<?php
if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridcrmrole'] == "Admin")
{
?>
                <li>
                  <a href="../requirement/create-requirement.php">Create Requirement</a>
                </li>
                <?php
}
?>
                    
<?php
if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridcrmrole'] == "Admin")
{
?>
                <li>
                  <a href="../requirement/view-requirement.php">Search for Manager</a>
                </li>
                <?php
}
?>

<?php
if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridcrmrole'] == "Admin")
{
?>
 <li>
                  <a href="../requirement/role.php">Grant Permission</a>
                </li>
                <?php
}
?>

<?php
if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridcrmrole'] == "Admin")
{
?>
 <li>
                  <a href="../requirement/view-client.php">Clients</a>
                </li>
                <?php
}
?>

<?php
if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridcrmrole'] == "Admin" || $_SESSION['tridcrmrole'] == "User")
{
?>
 <li>
                  <a href="../requirement/inbox.php">My Inbox</a>
                </li>
                <?php
}
?>

<?php
if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridcrmrole'] == "Admin" || $_SESSION['tridcrmrole'] == "User")
{
?> <li>
                  <a href="../requirement/view-candidate.php">Candidate Database</a>
                </li>
                <?php
}
?>

<?php
if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridcrmrole'] == "Admin" || $_SESSION['tridcrmrole'] == "User")
{
?><li>
                  <a href="../requirement/view-vendor.php">Vendor Database</a>
                </li>
                <?php
}
?>

<?php
if($_SESSION['tridcrmrole'] == "User")
{
?><li>
                  <a href="../requirement/view-vendor.php">Search for User</a>
                </li>
                <?php
}
?>
              </ul>
            </div>
          </li>
           <?php
          }
          ?>
          <?php 
          if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridtranslationrole'] == "TL" || $_SESSION['tridtranslationrole'] == "Admin"  || $_SESSION['tridtranslationrole'] == "User")
          {
          ?>
          </li>
           <li class="sidebar-dropdown">
            <a href="#">
              <i class="fa fa-calendar"></i>
              <spasn>Translation CRM</span>
            </a>
            <div class="sidebar-submenu">
              <ul>
                <?php
if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridtranslationrole'] == "TL")
{
?>
                <li>
                  <a href=".././translation-dashboard.php">Translation Dashboard</a>
                </li>
                <?php
}
?>

<?php
if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridtranslationrole'] == "TL" || $_SESSION['tridtranslationrole'] == "Admin" || $_SESSION['tridtranslationrole'] == "User")
{
?>
                <li>
                  <a href=".././translation/client.php">Client</a>
                </li>
                <?php
}
?>
<?php
if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridtranslationrole'] == "TL")
{
?>
                <li>
                  <a href=".././translation/role.php">Grant Permission</a>
                </li>
                <li>
                  <a href="../add-notice.php">Enquiry</a>
                </li>
                <li>
                  <a href=".././translation/enquiry-list.php">Enquiry List</a>
                </li>
                <?php
}
?>
                    
<?php
if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridtranslationrole'] == "TL" || $_SESSION['tridtranslationrole'] == "Admin")
{
?>
                <li>
                  <a href=".././translation/search-project.php">Project</a>
                </li>
                <?php
}
?>
<?php
if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridtranslationrole'] == "TL" || $_SESSION['tridtranslationrole'] == "Admin" || $_SESSION['tridtranslationrole'] == "User")
{
?>
                <li>
                  <a href="../add-notice.php">Translator Database</a>
                </li>
                <?php
}
?>
<?php
if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridtranslationrole'] == "TL" || $_SESSION['tridtranslationrole'] == "Admin" || $_SESSION['tridtranslationrole'] == "User")
{
?> <li>
                  <a href=".././translation/inbox.php">My Inbox</a>
                </li>
                <?php
}
?>

<?php
if($_SESSION['tridtranslationrole'] == "User")
{
?>
                 <li>
                  <a href="../add-notice.php">Project</a>
                </li>
              <?php
}
?>
              </ul>
            </div>
          <?php
          }
          ?>
        </ul>
      </div>
      <!-- sidebar-menu  -->
    </div>
    <!-- sidebar-content  -->
    <div class="sidebar-footer">
      <a href="#" class="hidden">
        <i class="fa fa-bell"></i>
        <span class="badge badge-pill badge-warning notification">3</span>
      </a>
      <a href="../../logout.php">
        <i class="fa fa-power-off"></i>
      </a>
    </div>
  </nav>
  <!-- sidebar-wrapper  -->
  <main class="page-content">   
    <div class="container">
      <div class="row">
    <header>
        <nav class="navbar navbar-expand-lg navbar-light bg-dark ">
            <div class="navbar-header" style="background-color: #c8e1fb!important;">
                <div class="col-sm-12 col-xs-12 col-md-4 col-lg-4" style="margin-top: 10px; padding-left: 10px">
                    <!-- Logo -->
                    <a class="logo" href="index.php">
                     <img src="../../plugins/images/admin-logo-dark.png" alt="home" class="light-logo" />
                    </a>
                </div>
                <div class="col-sm-12 col-xs-12 col-md-8 col-lg-8">
                <ul class="nav navbar-nav navbar-top-links">
                    <li>
                    <a class="profile-pic" href="#"> <b>Welcome Back <?php echo $_SESSION['tridname']?></b></a>
                    </li>
                    <li>
                        <a class="profile-pic" href="../../logout.php"><b>Log Out</b></a>
                    </li>
                </ul>
              </div>
            </div>
            <!-- /.navbar-header -->
            <!-- /.navbar-top-links -->
            <!-- /.navbar-static-side -->
        </nav>
</header>
</div>
</div>
<?php 
if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridrole'] == "HR")
{
date_default_timezone_set('Asia/Kolkata');
    $year = date("Y"); ?>
            <div class="container-fluid">
                <div class="row bg-title">
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                        <h4 class="page-title">Modify Attendance</h4> </div>
                        <form method="post">
                        <div class="row">
                    <div class="col-lg-4 col-sm-4 col-md-4 col-xs-4" style="margin-top: 30px">
                         Employeee Id* <input type="text" id="empcode" name="empcode" onchange="fetchname()" class="form-control" required>
                    </div>
                    <div id="empname" class="col-lg-4 col-sm-4 col-md-4 col-xs-4" style="margin-top: 30px">
                         Name <input type='text' class='form-control' readonly>
                    </div>

                    </div>
                    <div class="row">
                    <div class="col-lg-4 col-sm-4 col-md-4 col-xs-4" style="margin-top: 30px">
                         In time* <input class='form-control' type="datetime-local" name="intime" data-date-format="DD MMMM YYYY" placeholder="dd-mm-yyyy" required>
                    </div>
                    <div class="col-lg-4 col-sm-4 col-md-4 col-xs-4" style="margin-top: 30px">
                         Out Time* <input class='form-control' type="datetime-local" name="outtime" data-date-format="DD MMMM YYYY" placeholder="dd-mm-yyyy" required>
                    </div>
                    <div class="col-lg-4 col-sm-4 col-md-4 col-xs-4" style="margin-top: 30px">
                        Status* <select name="status" class='form-control' required>
                            <option value="">Select Status</option>
                            <option>Present by HR</option>
                            <option>Absent by HR</option>
                            <option>Halfday by HR</option>
                            <option>Present with Deductions By HR</option>
                            <option>Sandwitch by HR</option>   
                         </select>
                    </div>    


                    </div>
                <div class="row"> 

                     <div class="col-lg-12 col-sm-12 col-md-12 col-xs-12" style="margin-top: 30px">
                            <label>Comments*</label>
                            <textarea class="form-control" name="comment" required></textarea>
                     </div>                            
                    </div>

                <div class="row"> 
                    
                     <div class="col-lg-12 col-sm-12 col-md-12 col-xs-12" style="margin-top: 30px">
                            <input type="submit" name='search007' value="Change" class="btn">
                     </div>                            
                    </div>
                   </form>

                <!-- Content Goes Here-->
                </div>
            </div>
            <!-- /.container-fluid -->
        </div>
        <!-- ============================================================== -->
        <!-- End Page Content -->
        <!-- ============================================================== --> 
        <hr>
        <footer class="text-center">
        <div class="mb-2">
          <big>
            © <?php echo date("Y"); ?>  TRIDINDIA - IT TRANSLATION SERVICES PVT. LTD.
            </a>
          </big>
        </div>
      </footer>
    </div>
    <!-- /#wrapper -->
    <!-- jQuery -->
    <script src="../../plugins/bower_components/jquery/dist/jquery.min.js"></script>
    <!-- Bootstrap Core JavaScript -->
    <script src="../bootstrap/dist/js/bootstrap.min.js"></script>
    <!-- Menu Plugin JavaScript -->
    <script src="../../plugins/bower_components/sidebar-nav/dist/sidebar-nav.min.js"></script>
    <!--slimscroll JavaScript -->
    <script src="../js/jquery.slimscroll.js"></script>
    <!--Wave Effects -->
    <script src="../js/waves.js"></script>
    <!-- Custom Theme JavaScript -->
    <script src="../js/custom.min.js"></script>
<script src="js/vendor/jquery.sortelements.js" type="text/javascript"></script>
<script src="js/jquery.bdt.min.js" type="text/javascript"></script>
<script type="text/javascript">jQuery(function ($) {
        $(".sidebar-dropdown > a").click(function() {
          $(".sidebar-submenu").slideUp(200);
          if (
            $(this)
              .parent()
              .hasClass("active")
          ) {
            $(".sidebar-dropdown").removeClass("active");
            $(this)
              .parent()
              .removeClass("active");
          } else {
            $(".sidebar-dropdown").removeClass("active");
            $(this)
              .next(".sidebar-submenu")
              .slideDown(200);
            $(this)
              .parent()
              .addClass("active");
          }
        });
    $("#close-sidebar").click(function() {
      $(".page-wrapper").removeClass("toggled");
    });
    $("#show-sidebar").click(function() {
      $(".page-wrapper").addClass("toggled");
    });
    });
function fetchname(){
    var empcode = document.getElementById('empcode').value;
    if(empcode != "")
        {
            $.post("fetchajax.php",
            {
            e: empcode
            },
             function(data){
            document.getElementById('empname').innerHTML = data;
            });            
        }
}
  </script> 
  <?php
if(isset($_POST['search007']))
{

    $counterx = 0;
    $empcode = $conn->real_escape_string($_POST['empcode']);
    $intime = $conn->real_escape_string($_POST['intime']);
    $outtime = $conn->real_escape_string($_POST['outtime']);
    $status = $conn->real_escape_string($_POST['outtime']);
    $comment = $conn->real_escape_string($_POST['comment']);

    $intime = str_replace("T", " ", $intime);
    $outtime = str_replace("T", " ", $outtime);
    $status = $conn->real_escape_string($_POST['status']);

    $datein = new DateTime($intime);
    $din = $datein->format('Y-m-d');


    $dateout = new DateTime($outtime);
    $dout = $dateout->format('Y-m-d');


    $loginDate = "-";
    $loginTime = "-";
    $logoutDate = "-";
    $loginTime = "-";
    $status1 = "-";

    $sql = "SELECT t1.date as loginDate, t1.time as loginTime, t2.date as logoutDate, t2.time as logoutTime, t2.status as status FROM trid_login_time t1 join trid_logout_time t2 on (t1.employeeId = t2.employeeId and t1.date = t2.date) where t1.date = '$din' and t1.employeeId = '$empcode'";
    $result = $conn->query($sql);

    if ($result->num_rows > 0) {
        // output data of each row
        while($row = $result->fetch_assoc()) {
            $loginDate = $row['loginDate'];
            $loginTime = $row['loginTime'];
            $logoutDate = $row['logoutDate'];
            $logoutTime = $row['logoutTime'];
            $status1 = $row['status'];
        }
    }

$changes = $_SESSION['tridname'] . " (" . $_SESSION['tridid'] . ") Modified Attendance of EmployeeId - " . $empcode . " Login Time from " . $loginTime . " to " . $intime . ", Logout Time from " . $logoutTime . " to " . $outtime . " and Status from " . $status1 . " to " . $status . ", Comments - " . $comment; 

$eventBy = $_SESSION['tridname'] . " (" . $_SESSION['tridid'] . ")";
$eventType = "Modified Attendance";
date_default_timezone_set('Asia/Kolkata');
$datex = date("Y-m-d H:i:s");
    $workHours = (strtotime($outtime) - strtotime($intime)) / 3600;
    if($din != $dout)
    {
        echo "<script>alert('Date should be same.')</script>";
        die();
    }
    elseif(strtotime($outtime) <= strtotime($intime))
    {
        echo "<script>alert('Outtime should be greater than Intime.')</script>";
        die();
    }
    else
    {
        $sql = "SELECT * FROM trid_login_time where employeeId = '$empcode' and date = '$din'";
        $result = $conn->query($sql);

        if ($result->num_rows > 0) {
            $sql1 = "UPDATE trid_login_time SET employeeId = '$empcode', date = '$din', time = '$intime' where employeeId = '$empcode' and date = '$din'";
        }
        else
        {
            $sql1 = "INSERT INTO trid_login_time (employeeId, date, time) VALUES ('$empcode', '$din', '$intime')";
        }


        $sql = "SELECT * FROM trid_logout_time where employeeId = '$empcode' and date = '$dout'";
        $result = $conn->query($sql);

        if ($result->num_rows > 0) {
            $sql2 = "UPDATE trid_logout_time SET employeeId = '$empcode', date = '$dout', time = '$outtime', workHours = '$workHours', status = '$status' where employeeId = '$empcode' and date = '$dout'";
        }
        else
        {
            $sql2 = "INSERT INTO trid_logout_time (employeeId, date, time, workHours, status) VALUES ('$empcode', '$dout', '$outtime', '$workHours', '$status')";
        }
    }

    if ($conn->query($sql1) === TRUE) {        
    } 
    else {
    echo "<script>alert('Failed to Mark Attendance')</script>";
    die();
    }

    if ($conn->query($sql2) === TRUE) {
        $counterx = 1;

    } else {
        echo "<script>alert('Failed to Mark Attendance')</script>";
        die();
    }  

    if($counterx == 1)
    {
        $sql = "INSERT INTO trid_log (date, eventBy, eventType, Comment)
        VALUES ('$datex', '$eventBy', '$eventType', '$changes')";

        if ($conn->query($sql) === TRUE) {
            echo "<script>alert('Modified Attendance')</script>";
        } else {
            echo "<script>alert('Failed to Mark Attendance')</script>";
        }
    }

}
?>
</body>
<?php 
}
else
{
    echo "<script>window.location.href = '../../../index.php';</script>";
}
?>
</html>

