$(document).ready(function() {

	/**
	 * call the data.php file to fetch the result from db table.
	 */
	$.ajax({
		url : "graph/data.php",
		type : "GET",
		success : function(data){
			console.log(data);

			var score = {
				HR : [],
				Translation : [],
				IT : []
			};

			var len = data.length;

			for (var i = 0; i < len; i++) {
				if (data[i].department == "HR") {
					score.HR.push(data[i].quationamount);
				}
				else if (data[i].department == "Translation") {
					score.Translation.push(data[i].quationamount);
				}
				else if (data[i].department == "IT") {
					score.IT.push(data[i].quationamount);
				}
			}

			//get canvas
			var ctx = $("#line-chartcanvas");

			var data = {
				labels : ["USD", "INR", "EUR"],
				datasets : [
					{
						label : "HR score",
						data : score.HR,
						backgroundColor : "blue",
						borderColor : "lightblue",
						fill : false,
						lineTension : 0,
						pointRadius : 5
					},
					{
						label : "Translation score",
						data : score.Translation,
						backgroundColor : "green",
						borderColor : "lightgreen",
						fill : false,
						lineTension : 0,
						pointRadius : 5
					},
					{
						label : "IT score",
						data : score.IT,
						backgroundColor : "purple",
						borderColor : "purple",
						fill : false,
						lineTension : 0,
						pointRadius : 5
					}
				]
			};

			var options = {
				title : {
					display : true,
					position : "top",
					text : "Line Graph",
					fontSize : 18,
					fontColor : "#111"
				},
				legend : {
					display : true,
					position : "bottom"
				}
			};

			var chart = new Chart( ctx, {
				type : "line",
				data : data,
				options : options
			} );

		},
		error : function(data) {
			console.log(data);
		}
	});

});