<?php session_start(); ?>
<!DOCTYPE html>
<html lang="en">
<?php 

// Turn off error reporting
error_reporting(0);

// Report runtime errors
error_reporting(E_ERROR | E_WARNING | E_PARSE);

// Report all errors
error_reporting(E_ALL);

// Same as error_reporting(E_ALL);
ini_set("error_reporting", E_ALL);

// Report all errors except E_NOTICE
error_reporting(E_ALL & ~E_NOTICE);
require('../../../includes/connect.php');
?>
<head>
     <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">
    <link rel="icon" type="image/png" sizes="16x16" href="../../plugins/images/favicon.png">
    <title>View Attendance</title>
    <!-- Bootstrap Core CSS -->
    <link href="../bootstrap/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Menu CSS -->
    <link href="../../plugins/bower_components/sidebar-nav/dist/sidebar-nav.min.css" rel="stylesheet">
    <!-- animation CSS -->
    <link href="../css/animate.css" rel="stylesheet">
    <!-- Custom CSS -->
    <link href="../css/style.css" rel="stylesheet">
    <!-- color CSS -->
    <link href="../css/colors/default.css" id="theme" rel="stylesheet">
    <link href="css/vendor/font-awesome.min.css" type="text/css" rel="stylesheet">
     <link href="https://use.fontawesome.com/releases/v5.0.6/css/all.css" rel="stylesheet">
</head>

<body class="fix-header">
    <!-- ============================================================== -->
    <!-- Preloader -->
    <!-- ============================================================== -->
    <div class="preloader">
        <svg class="circular" viewBox="25 25 50 50">
            <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10" />
        </svg>
    </div>
    <!-- ============================================================== -->
    <!-- Wrapper -->
    <!-- ============================================================== -->
<div id="wrapper">
<div class="page-wrapper chiller-theme toggled">
  <a id="show-sidebar" class="btn btn-sm btn-dark" href="#">
    <i class="fas fa-bars"></i>
  </a>
  <nav id="sidebar" class="sidebar-wrapper">
    <div class="sidebar-content">
      <div class="sidebar-brand">
        <a href="#">Tridindia CRM</a>
        <div id="close-sidebar">
          <i class="fas fa-times"></i>
        </div>
      </div>
      <!-- sidebar-header  -->
      <div class="sidebar-menu">
        <ul>
          <li class="header-menu">
            <span>General</span>
          </li>
          <li>
            <a href="../index.php">
              <i class="fa fa-tachometer-alt"></i>
              <span>Dashboard</span>
            </a>
          </li>
          <li class="sidebar-dropdown">
            <a href="#">
              <i class="fa fa-user"></i>
              <span>User Panel</span>
            </a>
            <div class="sidebar-submenu">
              <ul>
                <li>
                  <a href="../attendance/view-attendance.php">Views Attendance</a>
                </li>
                <li>
                  <a href="../leaves/index.php">Apply for Leave</a>
                </li>
                <li>
                  <a href="../leaves/myleave.php">View Leaves</a>
                </li>
                 <li>
                  <a href="../attendance/change-password.php">Change Password</a>
                </li>

              </ul>
            </div>
          </li>
          <?php 
          if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridrole'] == "HR")
          {
          ?>
          <li class="sidebar-dropdown">
            <a  class="waves-effect"> <i class="fa fa-user-secret"></i>
             <span>HR Adminstration</span></a>
            <div class="sidebar-submenu">
              <ul>
                <li>
                  <a href="../newuser.php">Create User</a>
                </li>
                <li>
                  <a href="../viewuser/viewuser.php">Edit User</a>
                </li>
                <li>
                  <a href="../leaves/approveleave.php">Approve Leave</a>
                </li>
                <li>
                  <a href="../add-notice.php">Add New Notice</a>
                </li>
                <li>
                  <a href=".././document/relieving-letter.php">Relieving Letter</a>
                </li>
                <li>
                  <a href=".././document/offer-letter.php">Offer Letter</a>
                </li>
                <li>
                  <a href=".././document/appointment-letter.php">Appointment Letter</a>
                </li>
                <li>
                  <a href=".././document/increment-letter.php">Increment Letter</a>
                </li>
                 <li>
                  <a href=".././document/promotion-letter.php">Promotion Letter</a>
                </li>
                 <li>
                  <a href=".././document/salary-slip.php">Generate Salary & Slips</a>
                </li>
                 <li>
                  <a href=".././document/modify-attendance.php">Modify Attendance</a>
                </li>
                 <li>
                  <a href=".././document/lunch-timings.php">Lunch Timings</a>
                </li>
                 <li>
                  <a href=".././document/birthday.php">Birthday</a>
                </li>
                  <li>
                  <a href=".././attendance/view-attendance-hr.php">View Attendance HR</a>
                </li>
              </ul>
            </div>
          </li>
          <?php
          }
          ?>
          <?php 
          if($_SESSION['tridrole'] == "SuperAdmin")
          {
          ?>    
          <li class="sidebar-dropdown">
            <a href="#">
              <i class="fa fa-chart-line"></i>
              <spasn>Super Admin Panel</span>
            </a>
            <div class="sidebar-submenu">
              <ul>
                <li>
                  <a href="../hr-dashboard.php">HR Dashboard</a>
                </li>
                <li>
                  <a href="../translation-dashboard.php">Translation Dashboard</a>
                </li>
                <li>
                  <a href="../departments.php">Create Departments</a>
                </li>
                <li>
                  <a href="../add-notice.php">Add Notice</a>
                </li>
              </ul>
            </div>
          </li>
          <?php
          }
          ?>
          <?php
            if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridrole'] == "Manager")
            {
            ?>
          <li class="sidebar-dropdown">
            <a href="#">
              <i class="fa fa-globe"></i>
              <span>Manager Admin Panel</span>
            </a>
            <div class="sidebar-submenu">
              <ul>
                <li>
                  <a href="../leaves/approveleave.php">Approve Leave</a>
                </li>
                <li>
                  <a href=".././attendance/view-attendance-hr.php">View Attendance</a>
                </li>
                <li>
                  <a href=".././attendance/logs.php">Modify Attendance Logs</a>
                </li>
              </ul>
            </div>
          </li>
          <?php
          }
          ?>
          <?php 
        if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridcrmrole'] == "Admin" || $_SESSION['tridcrmrole'] == "User")
        {
        ?>
        <li class="header-menu">
            <span>Other</span>
          </li>
           <li class="sidebar-dropdown">
            <a href="#">
              <i class="fa fa-book"></i>
              <span>HR CRM</span>
            </a>
            <div class="sidebar-submenu">
              <ul>
                <?php
if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridcrmrole'] == "Admin")
{
?>

                <li>
                  <a href=".././hr-dashboard.php">HR Dashboard</a>
                </li>
                <?php
}
?>
<?php
if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridcrmrole'] == "Admin")
{
?>
                <li>
                  <a href="../requirement/create-requirement.php">Create Requirement</a>
                </li>
                <?php
}
?>
                    
<?php
if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridcrmrole'] == "Admin")
{
?>
                <li>
                  <a href="../requirement/view-requirement.php">Search for Manager</a>
                </li>
                <?php
}
?>

<?php
if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridcrmrole'] == "Admin")
{
?>
 <li>
                  <a href="../requirement/role.php">Grant Permission</a>
                </li>
                <?php
}
?>

<?php
if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridcrmrole'] == "Admin")
{
?>
 <li>
                  <a href="../requirement/view-client.php">Clients</a>
                </li>
                <?php
}
?>

<?php
if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridcrmrole'] == "Admin" || $_SESSION['tridcrmrole'] == "User")
{
?>
 <li>
                  <a href="../requirement/inbox.php">My Inbox</a>
                </li>
                <?php
}
?>

<?php
if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridcrmrole'] == "Admin" || $_SESSION['tridcrmrole'] == "User")
{
?> <li>
                  <a href="../requirement/view-candidate.php">Candidate Database</a>
                </li>
                <?php
}
?>

<?php
if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridcrmrole'] == "Admin" || $_SESSION['tridcrmrole'] == "User")
{
?><li>
                  <a href="../requirement/view-vendor.php">Vendor Database</a>
                </li>
                <?php
}
?>

<?php
if($_SESSION['tridcrmrole'] == "User")
{
?><li>
                  <a href="../requirement/view-vendor.php">Search for User</a>
                </li>
                <?php
}
?>
              </ul>
            </div>
          </li>
           <?php
          }
          ?>
          <?php 
          if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridtranslationrole'] == "TL" || $_SESSION['tridtranslationrole'] == "Admin"  || $_SESSION['tridtranslationrole'] == "User")
          {
          ?>
          </li>
           <li class="sidebar-dropdown">
            <a href="#">
              <i class="fa fa-calendar"></i>
              <spasn>Translation CRM</span>
            </a>
            <div class="sidebar-submenu">
              <ul>
                <?php
if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridtranslationrole'] == "TL")
{
?>
                <li>
                  <a href=".././translation-dashboard.php">Translation Dashboard</a>
                </li>
                <?php
}
?>

<?php
if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridtranslationrole'] == "TL" || $_SESSION['tridtranslationrole'] == "Admin" || $_SESSION['tridtranslationrole'] == "User")
{
?>
                <li>
                  <a href=".././translation/client.php">Client</a>
                </li>
                <?php
}
?>
<?php
if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridtranslationrole'] == "TL")
{
?>
                <li>
                  <a href=".././translation/role.php">Grant Permission</a>
                </li>
                <li>
                  <a href="../add-notice.php">Enquiry</a>
                </li>
                <li>
                  <a href=".././translation/enquiry-list.php">Enquiry List</a>
                </li>
                <?php
}
?>
                    
<?php
if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridtranslationrole'] == "TL" || $_SESSION['tridtranslationrole'] == "Admin")
{
?>
                <li>
                  <a href=".././translation/search-project.php">Project</a>
                </li>
                <?php
}
?>
<?php
if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridtranslationrole'] == "TL" || $_SESSION['tridtranslationrole'] == "Admin" || $_SESSION['tridtranslationrole'] == "User")
{
?>
                <li>
                  <a href="../add-notice.php">Translator Database</a>
                </li>
                <?php
}
?>
<?php
if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridtranslationrole'] == "TL" || $_SESSION['tridtranslationrole'] == "Admin" || $_SESSION['tridtranslationrole'] == "User")
{
?> <li>
                  <a href=".././translation/inbox.php">My Inbox</a>
                </li>
                <?php
}
?>

<?php
if($_SESSION['tridtranslationrole'] == "User")
{
?>
                 <li>
                  <a href="../add-notice.php">Project</a>
                </li>
              <?php
}
?>
              </ul>
            </div>
          <?php
          }
          ?>
        </ul>
      </div>
      <!-- sidebar-menu  -->
    </div>
    <!-- sidebar-content  -->
    <div class="sidebar-footer">
      <a href="#" class="hidden">
        <i class="fa fa-bell"></i>
        <span class="badge badge-pill badge-warning notification">3</span>
      </a>
      <a href="../../logout.php">
        <i class="fa fa-power-off"></i>
      </a>
    </div>
  </nav>
  <!-- sidebar-wrapper  -->
  <main class="page-content">   
    <div class="container">
      <div class="row">
    <header>
        <nav class="navbar navbar-expand-lg navbar-light bg-dark ">
            <div class="navbar-header" style="background-color: #c8e1fb!important;">
                <div class="col-sm-12 col-xs-12 col-md-4 col-lg-4" style="margin-top: 10px; padding-left: 10px">
                    <!-- Logo -->
                    <a class="logo" href="index.php">
                     <img src="../../plugins/images/admin-logo-dark.png" alt="home" class="light-logo" />
                    </a>
                </div>
                <div class="col-sm-12 col-xs-12 col-md-8 col-lg-8">
                <ul class="nav navbar-nav navbar-top-links">
                    <li>
                    <a class="profile-pic" href="#"> <b>Welcome Back <?php echo $_SESSION['tridname']?></b></a>
                    </li>
                    <li>
                        <a class="profile-pic" href="../../logout.php"><b>Log Out</b></a>
                    </li>
                </ul>
              </div>
            </div>
            <!-- /.navbar-header -->
            <!-- /.navbar-top-links -->
            <!-- /.navbar-static-side -->
        </nav>
</header>
</div>
</div>
<?php 
if($_SESSION['tridrole'] == "SuperAdmin" || $_SESSION['tridtranslationrole'] == "TL" || $_SESSION['tridtranslationrole'] == "Admin")
{
$id = $_SESSION['tridid']; ?>
<!-- page-wrapper -->
            <div class="container-fluid">
                <div class="row bg-title">
                    <div class="col-lg-3 col-md-4 col-sm-4 col-xs-12">
                        <h4 class="page-title">Add Project</h4> </div>
                    <div class="col-lg-9 col-sm-8 col-md-8 col-xs-12">
                    </div>
                    <!-- /.col-lg-12 -->
                </div>
                <div class="row">
                    <div class="col-md-12">




<form method="post" enctype='multipart/form-data'>


                         <div class="row">

                             <div class="col-xs-3 col-sm-3 col-md-3 col-lg-3" style="margin-top: 30px;">
                                <label>Date*</label>
                                <input type="datetime-local" class="form-control" name="date" required value="<?php
                                date_default_timezone_set('Asia/Kolkata');
                                $x = date("Y-m-d H:i:s");
                                $x = str_replace(" ", "T", $x);
                                echo $x;
                                ?>">
                             </div>
                             <div class="col-xs-3 col-sm-3 col-md-3 col-lg-3" style="margin-top: 30px;">
                                <label>Client Code*</label>
                                <select name="clientCode" required class="form-control" onchange="fetchCandidate(this.value)">
                                    <option value="">Select Client</option>
<?php 
$sql = "SELECT clientName,  clientCode FROM translation_client order by clientName";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    // output data of each row
    while($row = $result->fetch_assoc()) {
        echo "<option value='" . $row['clientCode'] . "'>" . $row['clientName'] . " (" . $row['clientCode'] . ")</option>";
    }
}
?>                                    

                                </select>
                             </div>



                             <div class="col-xs-3 col-sm-3 col-md-3 col-lg-3" style="margin-top: 30px;">
                                <label>Contact Person*</label>
                                <select name="candidate_email" id="candidate_email" required class="form-control" >
                                    
                                    <!-- Fetched by fetchCandidate() method -->

                                </select>
                             </div>
                         </div>
                         <div class="row">

                             <div class="col-xs-3 col-sm-3 col-md-3 col-lg-3" style="margin-top: 30px;">
                                <label>Source Language*</label>
                                <select class="form-control" required name="sourceLanguage[]" multiple="multiple">
                                        <option>Abkhazian</option>
                                        <option>Afar</option>
                                        <option>Afrikaans</option>
                                        <option>Akan</option>
                                        <option>Albanian</option>
                                        <option>Amharic</option>
                                        <option>Arabic</option>
                                        <option>Aragonese</option>
                                        <option>Aramaic</option>
                                        <option>Armenian</option>
                                        <option>Assamese</option>
                                        <option>Avaric</option>
                                        <option>Avestan</option>
                                        <option>Aymara</option>
                                        <option>Azerbaijani</option>
                                        <option>Balochi</option>
                                        <option>Bambara</option>
                                        <option>Bashkir</option>
                                        <option>Basque</option>
                                        <option>Belarusian</option>
                                        <option>Bemba</option>
                                        <option>Bengali</option>
                                        <option>Bhojpuri</option>
                                        <option>Bihari</option>
                                        <option>Bislama</option>
                                        <option>Bodo</option>
                                        <option>Bosnian</option>
                                        <option>Breton</option>
                                        <option>Bulgarian</option>
                                        <option>Burmese</option>
                                        <option>Catalan</option>
                                        <option>Cebuano</option>
                                        <option>Chamorro</option>
                                        <option>Chechen</option>
                                        <option>Chinese</option>
                                        <option>Church</option>
                                        <option>Chuvash</option>
                                        <option>Comorian</option>
                                        <option>Cornish</option>
                                        <option>Corsican</option>
                                        <option>Cree</option>
                                        <option>Creole</option>
                                        <option>Croatian</option>
                                        <option>Czech</option>
                                        <option>Dagbani</option>
                                        <option>Danish</option>
                                        <option>Dari</option>
                                        <option>Divehi</option>
                                        <option>Dogri</option>
                                        <option>Dutch</option>
                                        <option>Dzongkha</option>
                                        <option>English</option>
                                        <option>Esperanto</option>
                                        <option>Estonian</option>
                                        <option>Ewe</option>
                                        <option>Fang</option>
                                        <option>Fanti</option>
                                        <option>Faroese</option>
                                        <option>Fijian</option>
                                        <option>Finnish</option>
                                        <option>Flemish</option>
                                        <option>French</option>
                                        <option>Frisian</option>
                                        <option>Fulah</option>
                                        <option>Galician</option>
                                        <option>Ganda</option>
                                        <option>Georgian</option>
                                        <option>German</option>
                                        <option>Greek</option>
                                        <option>Guarani</option>
                                        <option>Gujarati</option>
                                        <option>Haitian</option>
                                        <option>Hausa</option>
                                        <option>Hebrew</option>
                                        <option>Herero</option>
                                        <option>Hindi</option>
                                        <option>Hiri-motu</option>
                                        <option>Hmong</option>
                                        <option>Hungarian</option>
                                        <option>Icelandic</option>
                                        <option>Ido</option>
                                        <option>Igbo</option>
                                        <option>Ilocano</option>
                                        <option>Indonesian</option>
                                        <option>Interlingua</option>
                                        <option>Inuktitut</option>
                                        <option>Inupiaq</option>
                                        <option>Irish</option>
                                        <option>Italian</option>
                                        <option>Japanese</option>
                                        <option>Javanese</option>
                                        <option>Kalaallisut</option>
                                        <option>Kannada</option>
                                        <option>Kanuri</option>
                                        <option>Kashmiri</option>
                                        <option>Kazakh</option>
                                        <option>Khasi</option>
                                        <option>Khmer</option>
                                        <option>Kikuyu</option>
                                        <option>Kimbundu</option>
                                        <option>Kinyarwanda</option>
                                        <option>Kirghiz</option>
                                        <option>Komi</option>
                                        <option>Kongo</option>
                                        <option>Konkani</option>
                                        <option>Korean</option>
                                        <option>Kuanyama</option>
                                        <option>Kunama</option>
                                        <option>Kurdish</option>
                                        <option>Kwanyama</option>
                                        <option>Kyrgyz</option>
                                        <option>Lao</option>
                                        <option>Latin</option>
                                        <option>Latvian</option>
                                        <option>Limburgish</option>
                                        <option>Lingala</option>
                                        <option>Lithuanian</option>
                                        <option>Luba-katanga</option>
                                        <option>Luxembourgish</option>
                                        <option>Macedonian</option>
                                        <option>Maithili</option>
                                        <option>Malagasy</option>
                                        <option>Malay</option>
                                        <option>Malayalam</option>
                                        <option>Maltese</option>
                                        <option>Maninka</option>
                                        <option>Manipuri</option>
                                        <option>Maori</option>
                                        <option>Marathi</option>
                                        <option>Marshallese</option>
                                        <option>Moldavian</option>
                                        <option>Mongolian</option>
                                        <option>Montengrin</option>
                                        <option>Moore</option>
                                        <option>Ndonga</option>
                                        <option>Nepali</option>
                                        <option>North</option>
                                        <option>Northern</option>
                                        <option>Norwegian</option>
                                        <option>Nuer</option>
                                        <option>Nyanja</option>
                                        <option>Occitan</option>
                                        <option>Ojibwa</option>
                                        <option>Oriya</option>
                                        <option>Oromo</option>
                                        <option>Pali</option>
                                        <option>Papiamentu</option>
                                        <option>Persian</option>
                                        <option>Polish</option>
                                        <option>Portuguese</option>
                                        <option>Punjabi</option>
                                        <option>Pushto</option>
                                        <option>Quechua</option>
                                        <option>Romanian</option>
                                        <option>Rundi</option>
                                        <option>Russian</option>
                                        <option>Samoan</option>
                                        <option>Sango</option>
                                        <option>Sanskrit</option>
                                        <option>Santhali</option>
                                        <option>Sardinian</option>
                                        <option>Scottish_gaelic</option>
                                        <option>Sepedi</option>
                                        <option>Serbian</option>
                                        <option>Serbo-croatian</option>
                                        <option>Shona</option>
                                        <option>Sichuan</option>
                                        <option>Sindhi</option>
                                        <option>Sinhalese</option>
                                        <option>Slovak</option>
                                        <option>Slovenian</option>
                                        <option>Somali</option>
                                        <option>Southern_sotho</option>
                                        <option>South_ndebele</option>
                                        <option>Spanish</option>
                                        <option>Sundanese</option>
                                        <option>Swahili</option>
                                        <option>Swati</option>
                                        <option>Swedish</option>
                                        <option>Sylheti</option>
                                        <option>Tagalog</option>
                                        <option>Tahitian</option>
                                        <option>Taiwanese</option>
                                        <option>Tajik</option>
                                        <option>Tamil</option>
                                        <option>Tatar</option>
                                        <option>Telugu</option>
                                        <option>Tetum</option>
                                        <option>Thai</option>
                                        <option>Tibetan</option>
                                        <option>Tigrinya</option>
                                        <option>Tlapaneco</option>
                                        <option>Tonga</option>
                                        <option>Tsonga</option>
                                        <option>Tswana</option>
                                        <option>Tumbuka</option>
                                        <option>Turkish</option>
                                        <option>Turkmen</option>
                                        <option>Tuvinian</option>
                                        <option>Twi</option>
                                        <option>Ukrainian</option>
                                        <option>Urdu</option>
                                        <option>Uyghur</option>
                                        <option>Uzbek</option>
                                        <option>Venda</option>
                                        <option>Vietnamese</option>
                                        <option>Volapuk</option>
                                        <option>Walloon</option>
                                        <option>Welsh</option>
                                        <option>Wolof</option>
                                        <option>Xhosa</option>
                                        <option>Yiddish</option>
                                        <option>Yoruba</option>
                                        <option>Zhuang</option>
                                        <option>Zulu</option>
                                </select>
                             </div>

                             <div class="col-xs-3 col-sm-3 col-md-3 col-lg-3" style="margin-top: 30px;">
                                <label>Destination Language*</label>
                                <select class="form-control" name="destinationLanguage[]" required multiple="multiple">
                                    
                                        <option>Abkhazian</option>
                                        <option>Afar</option>
                                        <option>Afrikaans</option>
                                        <option>Akan</option>
                                        <option>Albanian</option>
                                        <option>Amharic</option>
                                        <option>Arabic</option>
                                        <option>Aragonese</option>
                                        <option>Aramaic</option>
                                        <option>Armenian</option>
                                        <option>Assamese</option>
                                        <option>Avaric</option>
                                        <option>Avestan</option>
                                        <option>Aymara</option>
                                        <option>Azerbaijani</option>
                                        <option>Balochi</option>
                                        <option>Bambara</option>
                                        <option>Bashkir</option>
                                        <option>Basque</option>
                                        <option>Belarusian</option>
                                        <option>Bemba</option>
                                        <option>Bengali</option>
                                        <option>Bhojpuri</option>
                                        <option>Bihari</option>
                                        <option>Bislama</option>
                                        <option>Bodo</option>
                                        <option>Bosnian</option>
                                        <option>Breton</option>
                                        <option>Bulgarian</option>
                                        <option>Burmese</option>
                                        <option>Catalan</option>
                                        <option>Cebuano</option>
                                        <option>Chamorro</option>
                                        <option>Chechen</option>
                                        <option>Chinese</option>
                                        <option>Church</option>
                                        <option>Chuvash</option>
                                        <option>Comorian</option>
                                        <option>Cornish</option>
                                        <option>Corsican</option>
                                        <option>Cree</option>
                                        <option>Creole</option>
                                        <option>Croatian</option>
                                        <option>Czech</option>
                                        <option>Dagbani</option>
                                        <option>Danish</option>
                                        <option>Dari</option>
                                        <option>Divehi</option>
                                        <option>Dogri</option>
                                        <option>Dutch</option>
                                        <option>Dzongkha</option>
                                        <option>English</option>
                                        <option>Esperanto</option>
                                        <option>Estonian</option>
                                        <option>Ewe</option>
                                        <option>Fang</option>
                                        <option>Fanti</option>
                                        <option>Faroese</option>
                                        <option>Fijian</option>
                                        <option>Finnish</option>
                                        <option>Flemish</option>
                                        <option>French</option>
                                        <option>Frisian</option>
                                        <option>Fulah</option>
                                        <option>Galician</option>
                                        <option>Ganda</option>
                                        <option>Georgian</option>
                                        <option>German</option>
                                        <option>Greek</option>
                                        <option>Guarani</option>
                                        <option>Gujarati</option>
                                        <option>Haitian</option>
                                        <option>Hausa</option>
                                        <option>Hebrew</option>
                                        <option>Herero</option>
                                        <option>Hindi</option>
                                        <option>Hiri-motu</option>
                                        <option>Hmong</option>
                                        <option>Hungarian</option>
                                        <option>Icelandic</option>
                                        <option>Ido</option>
                                        <option>Igbo</option>
                                        <option>Ilocano</option>
                                        <option>Indonesian</option>
                                        <option>Interlingua</option>
                                        <option>Inuktitut</option>
                                        <option>Inupiaq</option>
                                        <option>Irish</option>
                                        <option>Italian</option>
                                        <option>Japanese</option>
                                        <option>Javanese</option>
                                        <option>Kalaallisut</option>
                                        <option>Kannada</option>
                                        <option>Kanuri</option>
                                        <option>Kashmiri</option>
                                        <option>Kazakh</option>
                                        <option>Khasi</option>
                                        <option>Khmer</option>
                                        <option>Kikuyu</option>
                                        <option>Kimbundu</option>
                                        <option>Kinyarwanda</option>
                                        <option>Kirghiz</option>
                                        <option>Komi</option>
                                        <option>Kongo</option>
                                        <option>Konkani</option>
                                        <option>Korean</option>
                                        <option>Kuanyama</option>
                                        <option>Kunama</option>
                                        <option>Kurdish</option>
                                        <option>Kwanyama</option>
                                        <option>Kyrgyz</option>
                                        <option>Lao</option>
                                        <option>Latin</option>
                                        <option>Latvian</option>
                                        <option>Limburgish</option>
                                        <option>Lingala</option>
                                        <option>Lithuanian</option>
                                        <option>Luba-katanga</option>
                                        <option>Luxembourgish</option>
                                        <option>Macedonian</option>
                                        <option>Maithili</option>
                                        <option>Malagasy</option>
                                        <option>Malay</option>
                                        <option>Malayalam</option>
                                        <option>Maltese</option>
                                        <option>Maninka</option>
                                        <option>Manipuri</option>
                                        <option>Maori</option>
                                        <option>Marathi</option>
                                        <option>Marshallese</option>
                                        <option>Moldavian</option>
                                        <option>Mongolian</option>
                                        <option>Montengrin</option>
                                        <option>Moore</option>
                                        <option>Ndonga</option>
                                        <option>Nepali</option>
                                        <option>North</option>
                                        <option>Northern</option>
                                        <option>Norwegian</option>
                                        <option>Nuer</option>
                                        <option>Nyanja</option>
                                        <option>Occitan</option>
                                        <option>Ojibwa</option>
                                        <option>Oriya</option>
                                        <option>Oromo</option>
                                        <option>Pali</option>
                                        <option>Papiamentu</option>
                                        <option>Persian</option>
                                        <option>Polish</option>
                                        <option>Portuguese</option>
                                        <option>Punjabi</option>
                                        <option>Pushto</option>
                                        <option>Quechua</option>
                                        <option>Romanian</option>
                                        <option>Rundi</option>
                                        <option>Russian</option>
                                        <option>Samoan</option>
                                        <option>Sango</option>
                                        <option>Sanskrit</option>
                                        <option>Santhali</option>
                                        <option>Sardinian</option>
                                        <option>Scottish_gaelic</option>
                                        <option>Sepedi</option>
                                        <option>Serbian</option>
                                        <option>Serbo-croatian</option>
                                        <option>Shona</option>
                                        <option>Sichuan</option>
                                        <option>Sindhi</option>
                                        <option>Sinhalese</option>
                                        <option>Slovak</option>
                                        <option>Slovenian</option>
                                        <option>Somali</option>
                                        <option>Southern_sotho</option>
                                        <option>South_ndebele</option>
                                        <option>Spanish</option>
                                        <option>Sundanese</option>
                                        <option>Swahili</option>
                                        <option>Swati</option>
                                        <option>Swedish</option>
                                        <option>Sylheti</option>
                                        <option>Tagalog</option>
                                        <option>Tahitian</option>
                                        <option>Taiwanese</option>
                                        <option>Tajik</option>
                                        <option>Tamil</option>
                                        <option>Tatar</option>
                                        <option>Telugu</option>
                                        <option>Tetum</option>
                                        <option>Thai</option>
                                        <option>Tibetan</option>
                                        <option>Tigrinya</option>
                                        <option>Tlapaneco</option>
                                        <option>Tonga</option>
                                        <option>Tsonga</option>
                                        <option>Tswana</option>
                                        <option>Tumbuka</option>
                                        <option>Turkish</option>
                                        <option>Turkmen</option>
                                        <option>Tuvinian</option>
                                        <option>Twi</option>
                                        <option>Ukrainian</option>
                                        <option>Urdu</option>
                                        <option>Uyghur</option>
                                        <option>Uzbek</option>
                                        <option>Venda</option>
                                        <option>Vietnamese</option>
                                        <option>Volapuk</option>
                                        <option>Walloon</option>
                                        <option>Welsh</option>
                                        <option>Wolof</option>
                                        <option>Xhosa</option>
                                        <option>Yiddish</option>
                                        <option>Yoruba</option>
                                        <option>Zhuang</option>
                                        <option>Zulu</option>
                                    
                                </select>
                             </div>




                         </div>
                        <div class="row">

                            <div class="col-xs-3 col-sm-3 col-md-3 col-lg-3" style="margin-top: 30px;">
                                <label>Word Count*</label>
                                <input type="text" name="wordCount" required class="form-control">
                             </div>
                            <div class="col-xs-3 col-sm-3 col-md-3 col-lg-3" style="margin-top: 30px;">
                                <label>Project Cost*</label>
                                <input type="number" step='any' name="projectCost" required class="form-control">
                             </div>
                             <div class="col-xs-2 col-sm-2 col-md-2 col-lg-2" style="margin-top: 30px;">
                                <label>Currency*</label>
                                <select class="form-control" name="currency">
                                    <option>INR</option>
                                    <option>USD</option>
                                    <option>EUR</option>
                                </select>
                             </div>
                             <div class="col-xs-3 col-sm-3 col-md-3 col-lg-3" style="margin-top: 30px;">
                                <label>Status*</label>
                                <select class="form-control" name="status">
                                    <option>Approved</option>
                                    <option>Acknowledged</option>
                                    <option>Work In Progress</option>
                                    <option>Send to Manager</option>
                                    <option>Finished</option>
                                </select>
                             </div>
                        </div>

                        <div class="row">

                            <div class="col-xs-3 col-sm-3 col-md-3 col-lg-3 " style="margin-top: 30px;">
                                <label>Deadline*</label>
                                <input type="datetime-local" class="form-control" name="deadline" required>
                             </div>
                             <div class="col-xs-3 col-sm-3 col-md-3 col-lg-3 " style="margin-top: 30px;">
                                <label>Assignee*</label>
                                <select required class="form-control" name="assignee">
                                    <option value="">Select Assignee</option>
<?php

$sql = "SELECT r.employeeId as employeeId, e.name as name FROM translation_role r join trid_employee_detail e on r.employeeId = e.employeeId";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    // output data of each row
    while($row = $result->fetch_assoc()) {
        echo "<option value='" . $row['employeeId'] . "'>" . $row['name'] . " (" . $row['employeeId'] . ")</option>";
    }
}

?>                                    
                
                                </select>
                             </div>
                        </div>

                        <div class="row">
                            <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12" style="margin-top: 30px;">
                                <label>Project Details*</label>
                                <textarea name="projectDetails" class="form-control" required></textarea>
                             </div>
                        </div>

                        <div class="row">

                            <div class="col-xs-3 col-sm-3 col-md-3 col-lg-3 " style="margin-top: 30px;">
                                <label>Upload File 1 (Optional)</label>
                                <input type="file" class="form-control" name="file1">
                             </div>
                            <div class="col-xs-3 col-sm-3 col-md-3 col-lg-3 " style="margin-top: 30px;">
                                <label>Upload File 2 (Optional)</label>
                                <input type="file" class="form-control" name="file2">
                             </div>
                            <div class="col-xs-3 col-sm-3 col-md-3 col-lg-3 " style="margin-top: 30px;">
                                <label>Upload File 3 (Optional)</label>
                                <input type="file" class="form-control" name="file3">
                             </div>
                            <div class="col-xs-3 col-sm-3 col-md-3 col-lg-3" style="margin-top: 30px;">
                                <label>Upload File 4 (Optional)</label>
                                <input type="file" class="form-control" name="file4">
                             </div>
                                                                                                                
                        </div>
                        <div class="row">
                            <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12" style="margin-top: 30px;">
                                <label>Comments*</label>
                                <textarea name="history" class="form-control" required></textarea>
                             </div>
                        </div>
                        <div class="row">

                            <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6" style="margin-top: 30px;">
                              <input type="submit" name="role007" class="btn"> 
                             </div>
                        </div>





 </form>                        
<!-- Content Goes Here-->
                </div>
            </div>
             <!-- /.container-fluid -->
        </div>
        <!-- ============================================================== -->
        <!-- End Page Content -->
        <!-- ============================================================== --> 
        <hr>
        <footer class="text-center">
        <div class="mb-2">
          <big>
            © <?php echo date("Y"); ?>  TRIDINDIA - IT TRANSLATION SERVICES PVT. LTD.
            </a>
          </big>
        </div>
      </footer>
    </div>
    <!-- /#wrapper -->
    <!-- jQuery -->
    <script src="../../plugins/bower_components/jquery/dist/jquery.min.js"></script>
    <!-- Bootstrap Core JavaScript -->
    <script src="../bootstrap/dist/js/bootstrap.min.js"></script>
    <!-- Menu Plugin JavaScript -->
    <script src="../../plugins/bower_components/sidebar-nav/dist/sidebar-nav.min.js"></script>
    <!--slimscroll JavaScript -->
    <script src="../js/jquery.slimscroll.js"></script>
    <!--Wave Effects -->
    <script src="../js/waves.js"></script>
    <!-- Custom Theme JavaScript -->
    <script src="../js/custom.min.js"></script>
<script src="js/vendor/jquery.sortelements.js" type="text/javascript"></script>
<script src="js/jquery.bdt.min.js" type="text/javascript"></script>
<script type="text/javascript">
  $(document).ready( function () {
        $('#bootstrap-table').bdt({
            showSearchForm: 0,
            showEntriesPerPageField: 0
        });
    });
    jQuery(function ($) {
        $(".sidebar-dropdown > a").click(function() {
          $(".sidebar-submenu").slideUp(200);
          if (
            $(this)
              .parent()
              .hasClass("active")
          ) {
            $(".sidebar-dropdown").removeClass("active");
            $(this)
              .parent()
              .removeClass("active");
          } else {
            $(".sidebar-dropdown").removeClass("active");
            $(this)
              .next(".sidebar-submenu")
              .slideDown(200);
            $(this)
              .parent()
              .addClass("active");
          }
        });
    $("#close-sidebar").click(function() {
      $(".page-wrapper").removeClass("toggled");
    });
    $("#show-sidebar").click(function() {
      $(".page-wrapper").addClass("toggled");
    });
    });

  </script><script>
function fetchCandidate(candidate) {
  var element = document.getElementById('candidate_email');  
  $.post("fetchCandidate.php",
  {
    code: candidate
  },
  function(data){
  element.innerHTML = data;
  });
}
</script>
<?php
if(isset($_POST['role007']))
{
        $filename1 = "";
        $file21 = "";
        $filename2 = "";
        $file22 = ""; 
        $filename3 = "";
        $file23 = "";    
        $filename4 = "";
        $file24 = "";  
        $counter = 0;                
    if($_FILES['file1']['size'] > 0)
    {
        $name = $_FILES["file1"]["name"];
        $ext = end((explode(".", $name)));
    

        if($ext != 'doc' && $ext != 'docx' && $ext != 'pdf' && $ext != 'zip')
        {
            echo "<script>alert('Please Upload only Word, Zip or PDF Files.')</script>";
            die();           
        }
        else
        {

        $filename1 = $_FILES['file1']['name'];
        $filename1 = str_replace("'", "", $filename1);
        $filename1 = str_replace('"', "", $filename1);
        do{    
        $file21 = date("YmdHis") . rand(1000, 99999999) . $filename1; 
        $t = "job_description/" . $file21;
        }while(file_exists($t));
    
            if(move_uploaded_file($_FILES['file1']['tmp_name'],$t))
            {

            }
            else
            {
                echo "<script>alert('Failed To Upload File.')</script>";
                die();
            }
        }

    }
    if($_FILES['file2']['size'] > 0)
    {
        $name = $_FILES["file2"]["name"];
        $ext = end((explode(".", $name)));
    

        if($ext != 'doc' && $ext != 'docx' && $ext != 'pdf' && $ext != 'zip')
        {
            echo "<script>alert('Please Upload only Word, Zip or PDF Files.')</script>";
            die();           
        }
        else
        {

        $filename2 = $_FILES['file2']['name'];
        $filename2 = str_replace("'", "", $filename2);
        $filename2 = str_replace('"', "", $filename2);        
        do{    
        $file22 = date("YmdHis") . rand(1000, 99999999) . $filename2; 
        $t = "job_description/" . $file22;
        }while(file_exists($t));
    
            if(move_uploaded_file($_FILES['file2']['tmp_name'],$t))
            {

            }
            else
            {
                echo "<script>alert('Failed To Upload File.')</script>";
                die();
            }
        }

    }
    if($_FILES['file3']['size'] > 0)
    {
        $name = $_FILES["file3"]["name"];
        $ext = end((explode(".", $name)));
    

        if($ext != 'doc' && $ext != 'docx' && $ext != 'pdf' && $ext != 'zip')
        {
            echo "<script>alert('Please Upload only Word, Zip or PDF Files.')</script>";
            die();           
        }
        else
        {

        $filename3 = $_FILES['file3']['name'];
        $filename3 = str_replace("'", "", $filename3);
        $filename3 = str_replace('"', "", $filename3);
        do{    
        $file23 = date("YmdHis") . rand(1000, 99999999) . $filename3; 
        $t = "job_description/" . $file23;
        }while(file_exists($t));
    
            if(move_uploaded_file($_FILES['file3']['tmp_name'],$t))
            {

            }
            else
            {
                echo "<script>alert('Failed To Upload File.')</script>";
                die();
            }
        }
    }
    if($_FILES['file4']['size'] > 0)
    {
        $name = $_FILES["file4"]["name"];
        $ext = end((explode(".", $name)));
    

        if($ext != 'doc' && $ext != 'docx' && $ext != 'pdf' && $ext != 'zip')
        {
            echo "<script>alert('Please Upload only Word, Zip or PDF Files.')</script>";
            die();           
        }
        else
        {

        $filename4 = $_FILES['file4']['name'];
        $filename4 = str_replace("'", "", $filename4);
        $filename4 = str_replace('"', "", $filename4);
        do{    
        $file24 = date("YmdHis") . rand(1000, 99999999) . $filename4; 
        $t = "job_description/" . $file24;
        }while(file_exists($t));
    
            if(move_uploaded_file($_FILES['file4']['tmp_name'],$t))
            {

            }
            else
            {
                echo "<script>alert('Failed To Upload File.')</script>";
                die();
            }
        }

    }            
    $date = $conn->real_escape_string($_POST['date']);
    $clientCode = $conn->real_escape_string($_POST['clientCode']);
    $x = $_POST['sourceLanguage'];
    $sourceLanguage = implode(", ",$x);
    $y = $_POST['destinationLanguage'];
    $destinationLanguage = implode(", ",$y);
    $projectDetails = $conn->real_escape_string($_POST['projectDetails']);
    $wordCount = $conn->real_escape_string($_POST['wordCount']);
    $projectCost = $conn->real_escape_string($_POST['projectCost']);
    $currency = $conn->real_escape_string($_POST['currency']);
    $status = $conn->real_escape_string($_POST['status']);
    $deadline = $conn->real_escape_string($_POST['deadline']);
    $assignee = $conn->real_escape_string($_POST['assignee']);
    $createdBy = $_SESSION['tridid'];
    $history = $conn->real_escape_string($_POST['history']);
    $candidate_email = $conn->real_escape_string($_POST['candidate_email']);    
    $history = date("Y-m-d H:i:s") . " " . $_SESSION['tridname'] . " (" . $_SESSION['tridid'] . ") Comments: " . $history;

$sql = "INSERT INTO translation_project (date, clientCode, projectDetails, sourceLanguage, destinationLanguage, wordCount, projectCost, currency, status, deadline, assignee, createdBy, history, file1, file2, file3, file4, candidate_email)
VALUES ('$date', '$clientCode', '$projectDetails', '$sourceLanguage', '$destinationLanguage', '$wordCount', '$projectCost', '$currency', '$status', '$deadline', '$assignee', '$createdBy', '$history', '$file21', '$file22', '$file23', '$file24', '$candidate_email')";

    if ($conn->query($sql) === TRUE) {
        $counter = 1;
        $last_id = mysqli_insert_id($conn);
    }
    else
    {
        echo "<script>alert('Problem Creating Project')</script>";
        die();
    }
    $jobCode = substr($clientCode, 0, 3) . $last_id;
    if($counter == 1)
    {
    $sql = "UPDATE translation_project SET jobCode = '$jobCode' WHERE id = '$last_id'";

    if ($conn->query($sql) === TRUE) {
        echo "<script>alert('Project Created - Job Code - " . $jobCode . "')</script>";
        echo "<script>window.location.href = 'add-project.php'</script>";
    } else {
        echo "<script>alert('Problem Creating Project')</script>";
    }
}

}
?>
</body>
<?php 
}
else
{
    echo "<script>window.location.href = '../../../index.php';</script>";
}
?>
</html>

